function [acv,ac]=autoD(d,variable,nLag,Demean,DisplayResults)
%	AUTOD - [acv,ac]=autoD(d,variable,nLag,Demean,DisplayResults)
%	construct acv's and ac's for data vectors in a structure array.
%	d is the structure array
%	variable is the variable name
%	nlag			max no of lags
%	Demean			0 or 1 (default=0)
%	DisplayResults	0 or 1 (default=0)

if nargin<4 | Demean
	xmean = eval(['mean(d.' variable ')']);
	Demean = 1;
else
	Demean=0;
end

if nargin<5
	DisplayResults=0;
end

acv = zeros(nLag+1,1);
ac = zeros(nLag+1,1);
n = zeros(nLag+1,1);
s = zeros(nLag+1,1);

for i=1:length(d)
	x = getfield(d(i),variable);
	if Demean
		x = x-mean;
	end
	for iLag=0:nLag
		m = length(x);
		n2 = m-iLag;
		if n2>0
			n(iLag+1) = n(iLag+1) + n2;
			s(iLag+1) = s(iLag+1) + sum( x(iLag+1:end).*x(1:m-iLag) );
		end
	end         
end
for i=1:(nLag+1)
	acv(i) = s(i)/n(i);
	ac(i) = acv(i)/acv(1);
end

if DisplayResults~=0
	disp(['Autocovariances and autocorrelations for ' variable]);
	disp([char('Lag',num2str((0:nLag)'))...
			char('         ACV ',num2str(acv))...
			char('    AC',num2str(ac,'%6.3f'))]);
end




